# Nine Three Merch - Website

## 🚗 About

Nine Three Merch LLC is a premium auto detailing service and merchandise store with locations in San Antonio, TX and Roxie, MS. This website showcases our services and products while providing an easy way for customers to connect with us.

## 🌟 Features

- **Modern Design**: Clean, professional website built with Next.js 15 and Tailwind CSS
- **Responsive Layout**: Fully responsive design that works on all devices
- **Service Showcase**: Detailed information about our auto detailing services
- **Product Gallery**: Browse our exclusive merchandise collection
- **Contact Form**: Easy way for customers to get in touch
- **Multiple Locations**: Information for both Texas and Mississippi locations

## 🛠️ Tech Stack

- **Framework**: Next.js 15 with App Router
- **Language**: TypeScript
- **Styling**: Tailwind CSS
- **UI Components**: Custom React components
- **Font**: Inter (Google Fonts)

## 📁 Project Structure

```
nine-three-merch/
├── app/                    # Next.js app directory
│   ├── layout.tsx         # Root layout with navigation
│   ├── page.tsx           # Homepage
│   ├── globals.css        # Global styles
│   ├── about/             # About page
│   ├── services/          # Services page
│   ├── shop/              # Shop/merchandise page
│   ├── gallery/           # Gallery page
│   └── contact/           # Contact page
├── components/            # Reusable React components
│   ├── Navigation.tsx     # Header navigation
│   ├── Footer.tsx        # Footer component
│   ├── Hero.tsx          # Homepage hero section
│   ├── Services.tsx      # Services showcase
│   ├── FeaturedProducts.tsx # Product showcase
│   └── About.tsx         # About section
├── public/               # Static assets
├── package.json          # Dependencies
└── tailwind.config.ts    # Tailwind configuration
```

## 🚀 Getting Started

### Prerequisites

- Node.js 18+ installed
- npm or yarn package manager

### Installation

1. Clone or download this project
2. Navigate to the project directory
3. Install dependencies:

```bash
npm install
```

### Development

Run the development server:

```bash
npm run dev
```

Open [http://localhost:3000](http://localhost:3000) in your browser to see the website.

### Production Build

Create an optimized production build:

```bash
npm run build
```

Start the production server:

```bash
npm run start
```

## 📄 Company Information

- **Legal Name**: Nine Three Merch LLC
- **EIN**: 39-3412571
- **Founded**: July 25, 2025
- **State of Formation**: Mississippi
- **Email**: raminc9321@gmail.com
- **Phone**: 1-800-829-4933

### Locations

**San Antonio, TX**
- 5414 Indian Pipe St
- San Antonio, TX 78242

**Roxie, MS**
- 3489 White Apple Rd
- Roxie, MS 39661

## 🎨 Customization

### Colors

The color scheme can be customized in `tailwind.config.ts`:
- Primary: Red (#FF0000)
- Secondary: Black (#000000)
- Accent: Gold (#FFD700)

### Content

To update content:
- Service offerings: Edit `components/Services.tsx`
- Product listings: Edit `components/FeaturedProducts.tsx` and `app/shop/page.tsx`
- Contact information: Edit `components/Footer.tsx` and `app/contact/page.tsx`
- About content: Edit `components/About.tsx` and `app/about/page.tsx`

## 📱 Pages

- **Home** (`/`) - Landing page with hero, services, and featured products
- **Services** (`/services`) - Detailed auto detailing service information
- **Shop** (`/shop`) - Browse merchandise and products
- **Gallery** (`/gallery`) - Showcase of completed work
- **About** (`/about`) - Company information and history
- **Contact** (`/contact`) - Contact form and location details

## 🔧 Future Enhancements

- [ ] Add real product images
- [ ] Implement shopping cart functionality
- [ ] Add online booking system for services
- [ ] Integrate payment processing
- [ ] Add customer reviews/testimonials
- [ ] Implement email notifications for contact form
- [ ] Add SEO optimizations
- [ ] Connect to a CMS for easy content management

## 📝 License

© 2025 Nine Three Merch LLC. All rights reserved.

---

Built with ❤️ for Nine Three Merch
